/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.FileChooserUI;
import com.sun.java.swing.preview.FileType;
import com.sun.java.swing.preview.JDirectoryPane;
import com.sun.java.swing.preview.TypedFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class JFileChooser
extends JComponent
implements SwingConstants,
Accessible {
    protected Vector choosableTypes = new Vector();
    protected String prompt = DefaultPrompt;
    protected String typesTitle = DefaultTypesTitle;
    protected String locationTitle = DefaultLocationTitle;
    protected String okayTitle = DefaultOkayTitle;
    protected String cancelTitle = DefaultCancelTitle;
    protected static String DefaultPrompt = "File Name:";
    protected static String DefaultTypesTitle = "Files of Type:";
    protected static String DefaultLocationTitle = "Look in:";
    protected static String DefaultOkayTitle = "OK";
    protected static String DefaultCancelTitle = "Cancel";
    protected String okayCommand = DefaultOkayCommand;
    protected String cancelCommand = DefaultCancelCommand;
    protected static String DefaultOkayCommand = "OKAY";
    protected static String DefaultCancelCommand = "CANCEL";
    protected JDirectoryPane directoryPane;
    protected Component accessory;
    static /* synthetic */ Class class$java$awt$Frame;

    public JFileChooser() {
        this((File)null);
    }

    public JFileChooser(String string) {
        this(string == null ? null : new File(string));
    }

    public JFileChooser(File file) {
        this.directoryPane = new JDirectoryPane(file);
        this.updateUI();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String string) {
        String string2 = this.prompt;
        this.prompt = string;
        this.firePropertyChange("prompt", string2, string);
    }

    public String getTypesTitle() {
        return this.typesTitle;
    }

    public void setTypesTitle(String string) {
        String string2 = this.typesTitle;
        this.typesTitle = string;
        this.firePropertyChange("typesTitle", string2, string);
    }

    public String getLocationTitle() {
        return this.locationTitle;
    }

    public void setLocationTitle(String string) {
        String string2 = this.locationTitle;
        this.locationTitle = string;
        this.firePropertyChange("locationTitle", string2, string);
    }

    public String getOkayTitle() {
        return this.okayTitle;
    }

    public void setOkayTitle(String string) {
        String string2 = this.okayTitle;
        this.okayTitle = string;
        this.firePropertyChange("okayTitle", string2, string);
    }

    public String getCancelTitle() {
        return this.cancelTitle;
    }

    public void setCancelTitle(String string) {
        String string2 = this.cancelTitle;
        this.cancelTitle = string;
        this.firePropertyChange("cancelTitle", string2, string);
    }

    public JDirectoryPane getDirectoryPane() {
        return this.directoryPane;
    }

    public TypedFile getSelectedFile() {
        return this.directoryPane.getSelectedFile();
    }

    public void performOkay() {
        this.directoryPane.fireActionPerformed(this.getOkayCommand());
    }

    public void performCancel() {
        this.directoryPane.fireActionPerformed(this.getCancelCommand());
    }

    public String getOkayCommand() {
        return this.okayCommand;
    }

    public void setOkayCommand(String string) {
        String string2 = this.okayCommand;
        this.okayCommand = string;
        this.firePropertyChange("okayCommand", string2, string);
    }

    public String getCancelCommand() {
        return this.cancelCommand;
    }

    public void setCancelCommand(String string) {
        String string2 = this.cancelCommand;
        this.cancelCommand = string;
        this.firePropertyChange("cancelCommand", string2, string);
    }

    public int showDialog(Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = JFileChooser.class$("java.awt.Frame")), component);
        JDialog jDialog = new JDialog(frame, "Save", true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        ModalListener modalListener = new ModalListener(jDialog);
        this.directoryPane.addActionListener(modalListener);
        jDialog.show();
        this.directoryPane.removeActionListener(modalListener);
        return modalListener.returnValue;
    }

    public Component getAccessory() {
        return this.accessory;
    }

    public void setAccessory(Component component) {
        Component component2 = this.accessory;
        if (component2 instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)component2));
        }
        if (component2 instanceof ActionListener) {
            this.directoryPane.removeActionListener((ActionListener)((Object)component2));
        }
        this.accessory = component;
        if (component instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)((Object)component));
        }
        if (component instanceof ActionListener) {
            this.directoryPane.addActionListener((ActionListener)((Object)component));
        }
        this.firePropertyChange("accessory", component2, component);
    }

    public void addChoosableFileType(String string, String string2, Icon icon) {
        FileType.ExtensionBased extensionBased = new FileType.ExtensionBased(string, string2, icon);
        this.addChoosableFileType(extensionBased);
    }

    public void addChoosableFileType(String string, String[] stringArray, Icon icon) {
        FileType.ExtensionBased extensionBased = new FileType.ExtensionBased(string, stringArray, icon);
        this.addChoosableFileType(extensionBased);
    }

    public void addChoosableFileType(FileType fileType) {
        if (!this.choosableTypes.contains(fileType)) {
            this.choosableTypes.addElement(fileType);
        }
        if (!this.directoryPane.isKnownFileType(fileType)) {
            this.directoryPane.addKnownFileType(fileType);
        }
        this.firePropertyChange("choosableFileTypes", null, null);
    }

    public Enumeration enumerateChoosableFileTypes() {
        return this.choosableTypes.elements();
    }

    public Vector getChoosableFileTypes() {
        return (Vector)this.choosableTypes.clone();
    }

    public boolean isChoosableFileType(FileType fileType) {
        return this.choosableTypes.contains(fileType);
    }

    public void setChoosableFileTypes(FileType[] fileTypeArray) {
        int n = fileTypeArray.length;
        Vector<FileType> vector = this.choosableTypes = new Vector<FileType>(n);
        vector.setSize(n);
        int n2 = 0;
        while (n2 < n) {
            FileType fileType = fileTypeArray[n2];
            vector.setElementAt(fileType, n2);
            ++n2;
        }
        this.firePropertyChange("choosableFileTypes", null, null);
    }

    public void updateUI() {
        this.setUI((FileChooserUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "FileChooserUI";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFileChooser();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ModalListener
    implements ActionListener {
        public int returnValue = -1;
        JDialog dialog;

        public ModalListener(JDialog jDialog) {
            JFileChooser.this = JFileChooser.this;
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals(JFileChooser.this.getOkayCommand())) {
                    this.returnValue = 0;
                    ((Component)this.dialog).setVisible(false);
                }
                if (string.equals(JFileChooser.this.getCancelCommand())) {
                    this.returnValue = -1;
                    ((Component)this.dialog).setVisible(false);
                }
            }
        }
    }

    protected class AccessibleJFileChooser
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILE_CHOOSER;
        }

        AccessibleJFileChooser() {
            JFileChooser.this = JFileChooser.this;
        }
    }
}

